import { Award, Users, Truck, Headphones, TrendingUp, Shield } from 'lucide-react';
import { Card, CardContent } from '@/components/ui/card';
import { useLanguage } from '@/contexts/LanguageContext';

export function About() {
  const { t } = useLanguage();

  const stats = [
    { value: '10,000+', label: t('مشتری راضی', 'Happy Customers') },
    { value: '5,000+', label: t('محصول', 'Products') },
    { value: '50+', label: t('برند معتبر', 'Trusted Brands') },
    { value: '24/7', label: t('پشتیبانی', 'Support') },
  ];

  const features = [
    {
      icon: Shield,
      title: t('ضمانت اصالت', 'Authenticity Guarantee'),
      description: t('تمامی محصولات 100% اورجینال و با گارانتی معتبر', 'All products are 100% original with valid warranty'),
    },
    {
      icon: Truck,
      title: t('ارسال سریع', 'Fast Delivery'),
      description: t('ارسال به سراسر کشور در کمترین زمان ممکن', 'Nationwide delivery in minimum time'),
    },
    {
      icon: Headphones,
      title: t('پشتیبانی حرفه‌ای', 'Professional Support'),
      description: t('تیم پشتیبانی متخصص در خدمت شما', 'Expert support team at your service'),
    },
    {
      icon: TrendingUp,
      title: t('قیمت رقابتی', 'Competitive Prices'),
      description: t('بهترین قیمت‌ها در بازار را تضمین می‌کنیم', 'We guarantee the best market prices'),
    },
  ];

  const team = [
    { name: 'علی محمدی', role: t('مدیر عامل', 'CEO'), image: 'https://images.unsplash.com/photo-1507003211169-0a1dd7228f2d?w=200' },
    { name: 'سارا کریمی', role: t('مدیر فروش', 'Sales Manager'), image: 'https://images.unsplash.com/photo-1494790108377-be9c29b29330?w=200' },
    { name: 'رضا احمدی', role: t('مدیر فنی', 'Technical Manager'), image: 'https://images.unsplash.com/photo-1500648767791-00dcc994a43e?w=200' },
    { name: 'مریم رضایی', role: t('پشتیبانی', 'Support'), image: 'https://images.unsplash.com/photo-1438761681033-6461ffad8d80?w=200' },
  ];

  return (
    <div className="min-h-screen py-8">
      <div className="container mx-auto px-4">
        {/* Hero */}
        <div className="text-center mb-16">
          <h1 className="text-3xl md:text-5xl font-bold mb-6">
            {t('درباره فروشگاه دیجیتال', 'About Digital Shop')}
          </h1>
          <p className="text-lg text-muted-foreground max-w-3xl mx-auto leading-relaxed">
            {t(
              'فروشگاه دیجیتال با هدف ارائه بهترین محصولات دیجیتال با قیمت مناسب و کیفیت عالی تأسیس شده است. ما به مشتریان خود تعهد می‌دهیم که تنها محصولات اورجینال و با گارانتی معتبر ارائه دهیم.',
              'Digital Shop was established with the goal of providing the best digital products at reasonable prices and excellent quality. We are committed to offering only original products with valid warranties.'
            )}
          </p>
        </div>

        {/* Stats */}
        <div className="grid grid-cols-2 md:grid-cols-4 gap-6 mb-16">
          {stats.map((stat, index) => (
            <Card key={index}>
              <CardContent className="p-6 text-center">
                <p className="text-3xl md:text-4xl font-bold text-primary mb-2">{stat.value}</p>
                <p className="text-muted-foreground">{stat.label}</p>
              </CardContent>
            </Card>
          ))}
        </div>

        {/* Features */}
        <div className="mb-16">
          <h2 className="text-2xl md:text-3xl font-bold text-center mb-8">
            {t('چرا ما؟', 'Why Choose Us?')}
          </h2>
          <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            {features.map((feature, index) => (
              <Card key={index} className="text-center">
                <CardContent className="p-6">
                  <div className="w-16 h-16 bg-primary/10 rounded-full flex items-center justify-center mx-auto mb-4">
                    <feature.icon className="h-8 w-8 text-primary" />
                  </div>
                  <h3 className="font-bold text-lg mb-2">{feature.title}</h3>
                  <p className="text-muted-foreground text-sm">{feature.description}</p>
                </CardContent>
              </Card>
            ))}
          </div>
        </div>

        {/* Team */}
        <div className="mb-16">
          <h2 className="text-2xl md:text-3xl font-bold text-center mb-8">
            {t('تیم ما', 'Our Team')}
          </h2>
          <div className="grid grid-cols-2 md:grid-cols-4 gap-6">
            {team.map((member, index) => (
              <div key={index} className="text-center">
                <div className="w-32 h-32 mx-auto mb-4 rounded-full overflow-hidden">
                  <img src={member.image} alt={member.name} className="w-full h-full object-cover" />
                </div>
                <h3 className="font-bold">{member.name}</h3>
                <p className="text-muted-foreground text-sm">{member.role}</p>
              </div>
            ))}
          </div>
        </div>

        {/* Mission */}
        <div className="bg-muted rounded-2xl p-8 md:p-12 text-center">
          <Award className="h-16 w-16 mx-auto mb-6 text-primary" />
          <h2 className="text-2xl md:text-3xl font-bold mb-4">
            {t('مأموریت ما', 'Our Mission')}
          </h2>
          <p className="text-muted-foreground max-w-3xl mx-auto leading-relaxed">
            {t(
              'ما باور داریم که تکنولوژی باید در دسترس همه باشد. مأموریت ما ارائه بهترین محصولات دیجیتال با قیمت مناسب و خدمات عالی به مشتریان است. ما همیشه در تلاشیم تا تجربه خریدی لذت‌بخش و مطمئن را برای شما فراهم کنیم.',
              'We believe technology should be accessible to everyone. Our mission is to provide the best digital products at affordable prices with excellent customer service. We always strive to provide a pleasant and secure shopping experience for you.'
            )}
          </p>
        </div>
      </div>
    </div>
  );
}
