import type { Product, Category, BlogPost, Banner } from '@/types';

export const sampleCategories: Category[] = [
  {
    id: 'cat-1',
    name: 'لپ‌تاپ',
    nameEn: 'Laptops',
    description: 'جدیدترین لپ‌تاپ‌های روز دنیا',
    descriptionEn: 'Latest laptops from around the world',
    image: 'https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=400',
    icon: 'Laptop',
    sortOrder: 1,
    isActive: true,
  },
  {
    id: 'cat-2',
    name: 'موبایل',
    nameEn: 'Mobile Phones',
    description: 'گوشی‌های هوشمند پرچم‌دار',
    descriptionEn: 'Flagship smartphones',
    image: 'https://images.unsplash.com/photo-1511707171634-5f897ff02aa9?w=400',
    icon: 'Smartphone',
    sortOrder: 2,
    isActive: true,
  },
  {
    id: 'cat-3',
    name: 'تبلت',
    nameEn: 'Tablets',
    description: 'تبلت‌های حرفه‌ای و کاربردی',
    descriptionEn: 'Professional and practical tablets',
    image: 'https://images.unsplash.com/photo-1544244015-0df4b3ffc6b0?w=400',
    icon: 'Tablet',
    sortOrder: 3,
    isActive: true,
  },
  {
    id: 'cat-4',
    name: 'هدفون',
    nameEn: 'Headphones',
    description: 'هدفون و هدست با کیفیت',
    descriptionEn: 'Quality headphones and headsets',
    image: 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=400',
    icon: 'Headphones',
    sortOrder: 4,
    isActive: true,
  },
  {
    id: 'cat-5',
    name: 'ساعت هوشمند',
    nameEn: 'Smart Watches',
    description: 'ساعت‌های هوشمند ورزشی و کلاسیک',
    descriptionEn: 'Sports and classic smartwatches',
    image: 'https://images.unsplash.com/photo-1523275335684-37898b6baf30?w=400',
    icon: 'Watch',
    sortOrder: 5,
    isActive: true,
  },
  {
    id: 'cat-6',
    name: 'دوربین',
    nameEn: 'Cameras',
    description: 'دوربین‌های عکاسی و فیلم‌برداری',
    descriptionEn: 'Photography and video cameras',
    image: 'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=400',
    icon: 'Camera',
    sortOrder: 6,
    isActive: true,
  },
  {
    id: 'cat-7',
    name: 'گیمینگ',
    nameEn: 'Gaming',
    description: 'تجهیزات گیمینگ و بازی',
    descriptionEn: 'Gaming equipment and accessories',
    image: 'https://images.unsplash.com/photo-1542751371-adc38448a05e?w=400',
    icon: 'Gamepad2',
    sortOrder: 7,
    isActive: true,
  },
  {
    id: 'cat-8',
    name: 'لوازم جانبی',
    nameEn: 'Accessories',
    description: 'لوازم جانبی کامپیوتر و موبایل',
    descriptionEn: 'Computer and mobile accessories',
    image: 'https://images.unsplash.com/photo-1550009158-9ebf690569ba?w=400',
    icon: 'Cable',
    sortOrder: 8,
    isActive: true,
  },
];

export const sampleProducts: Product[] = [
  {
    id: 'prod-1',
    name: 'لپ‌تاپ اپل MacBook Pro 14',
    nameEn: 'Apple MacBook Pro 14',
    description: 'لپ‌تاپ قدرتمند اپل با پردازنده M3 Pro، 18 گیگابایت رم و 512 گیگابایت SSD. صفحه نمایش 14 اینچی Retina XDR با کیفیت بی‌نظیر.',
    descriptionEn: 'Powerful Apple laptop with M3 Pro processor, 18GB RAM and 512GB SSD. 14-inch Retina XDR display with stunning quality.',
    price: 85000000,
    originalPrice: 92000000,
    images: [
      'https://images.unsplash.com/photo-1517336714731-489689fd1ca8?w=600',
      'https://images.unsplash.com/photo-1611186871348-b1ce696e52c9?w=600',
    ],
    category: 'cat-1',
    stock: 15,
    sku: 'MBP14-M3PRO',
    specifications: {
      'پردازنده': 'Apple M3 Pro',
      'رم': '18 گیگابایت',
      'حافظه': '512 گیگابایت SSD',
      'صفحه نمایش': '14.2 اینچ Retina XDR',
      'باتری': 'تا 18 ساعت',
    },
    specificationsEn: {
      'Processor': 'Apple M3 Pro',
      'RAM': '18GB',
      'Storage': '512GB SSD',
      'Display': '14.2 inch Retina XDR',
      'Battery': 'Up to 18 hours',
    },
    rating: 4.9,
    reviewCount: 128,
    isFeatured: true,
    isNew: true,
    discount: 8,
    tags: ['اپل', 'لپ‌تاپ', 'حرفه‌ای'],
    createdAt: '2024-01-15T10:00:00Z',
    updatedAt: '2024-01-15T10:00:00Z',
  },
  {
    id: 'prod-2',
    name: 'لپ‌تاپ ایسوس ROG Strix G15',
    nameEn: 'ASUS ROG Strix G15',
    description: 'لپ‌تاپ گیمینگ قدرتمند با پردازنده Ryzen 9 و کارت گرافیک RTX 4070. مناسب برای گیمینگ و کارهای گرافیکی سنگین.',
    descriptionEn: 'Powerful gaming laptop with Ryzen 9 processor and RTX 4070 graphics. Perfect for gaming and heavy graphics work.',
    price: 45000000,
    originalPrice: 52000000,
    images: [
      'https://images.unsplash.com/photo-1603302576837-37561b2e2302?w=600',
    ],
    category: 'cat-1',
    subcategory: 'cat-7',
    stock: 8,
    sku: 'ROG-G15-RTX4070',
    specifications: {
      'پردازنده': 'AMD Ryzen 9 7945HX',
      'کارت گرافیک': 'NVIDIA RTX 4070',
      'رم': '32 گیگابایت',
      'حافظه': '1 ترابایت SSD',
      'صفحه نمایش': '15.6 اینچ 165Hz',
    },
    specificationsEn: {
      'Processor': 'AMD Ryzen 9 7945HX',
      'Graphics': 'NVIDIA RTX 4070',
      'RAM': '32GB',
      'Storage': '1TB SSD',
      'Display': '15.6 inch 165Hz',
    },
    rating: 4.7,
    reviewCount: 89,
    isFeatured: true,
    isNew: false,
    discount: 13,
    tags: ['گیمینگ', 'ایسوس', 'RTX'],
    createdAt: '2024-01-10T10:00:00Z',
    updatedAt: '2024-01-10T10:00:00Z',
  },
  {
    id: 'prod-3',
    name: 'آیفون 15 پرو مکس',
    nameEn: 'iPhone 15 Pro Max',
    description: 'جدیدترین گوشی پرچم‌دار اپل با بدنه تیتانیوم، پردازنده A17 Pro و دوربین 48 مگاپیکسلی.',
    descriptionEn: 'Latest Apple flagship with titanium body, A17 Pro processor and 48MP camera.',
    price: 78000000,
    originalPrice: 82000000,
    images: [
      'https://images.unsplash.com/photo-1696446701796-da61225697cc?w=600',
      'https://images.unsplash.com/photo-1695048133142-1a20484d2569?w=600',
    ],
    category: 'cat-2',
    stock: 25,
    sku: 'IP15PM-256',
    specifications: {
      'صفحه نمایش': '6.7 اینچ Super Retina XDR',
      'پردازنده': 'A17 Pro',
      'دوربین اصلی': '48 مگاپیکسل',
      'حافظه': '256 گیگابایت',
      'باتری': 'تا 29 ساعت پخش ویدیو',
    },
    specificationsEn: {
      'Display': '6.7 inch Super Retina XDR',
      'Processor': 'A17 Pro',
      'Main Camera': '48MP',
      'Storage': '256GB',
      'Battery': 'Up to 29 hours video playback',
    },
    rating: 4.8,
    reviewCount: 256,
    isFeatured: true,
    isNew: true,
    discount: 5,
    tags: ['اپل', 'آیفون', 'پرچم‌دار'],
    createdAt: '2024-01-20T10:00:00Z',
    updatedAt: '2024-01-20T10:00:00Z',
  },
  {
    id: 'prod-4',
    name: 'سامسونگ Galaxy S24 Ultra',
    nameEn: 'Samsung Galaxy S24 Ultra',
    description: 'گوشی پرچم‌دار سامسونگ با قلم S Pen، دوربین 200 مگاپیکسلی و قابلیت‌های هوش مصنوعی.',
    descriptionEn: 'Samsung flagship with S Pen, 200MP camera and AI capabilities.',
    price: 65000000,
    originalPrice: 70000000,
    images: [
      'https://images.unsplash.com/photo-1610945265078-3858a0828671?w=600',
    ],
    category: 'cat-2',
    stock: 18,
    sku: 'GS24U-512',
    specifications: {
      'صفحه نمایش': '6.8 اینچ Dynamic AMOLED',
      'پردازنده': 'Snapdragon 8 Gen 3',
      'دوربین اصلی': '200 مگاپیکسل',
      'حافظه': '512 گیگابایت',
      'باتری': '5000 میلی‌آمپر',
    },
    specificationsEn: {
      'Display': '6.8 inch Dynamic AMOLED',
      'Processor': 'Snapdragon 8 Gen 3',
      'Main Camera': '200MP',
      'Storage': '512GB',
      'Battery': '5000mAh',
    },
    rating: 4.6,
    reviewCount: 178,
    isFeatured: false,
    isNew: true,
    discount: 7,
    tags: ['سامسونگ', 'گلکسی', 'S Pen'],
    createdAt: '2024-01-18T10:00:00Z',
    updatedAt: '2024-01-18T10:00:00Z',
  },
  {
    id: 'prod-5',
    name: 'آیپد پرو 12.9 اینچ M2',
    nameEn: 'iPad Pro 12.9-inch M2',
    description: 'تبلت حرفه‌ای اپل با پردازنده M2، صفحه نمایش mini-LED و پشتیبانی از Apple Pencil.',
    descriptionEn: 'Professional Apple tablet with M2 processor, mini-LED display and Apple Pencil support.',
    price: 52000000,
    originalPrice: 58000000,
    images: [
      'https://images.unsplash.com/photo-1544244015-0df4b3ffc6b0?w=600',
    ],
    category: 'cat-3',
    stock: 12,
    sku: 'IPADPRO-129-M2',
    specifications: {
      'صفحه نمایش': '12.9 اینچ Liquid Retina XDR',
      'پردازنده': 'Apple M2',
      'رم': '8 گیگابایت',
      'حافظه': '256 گیگابایت',
      'دوربین': '12 مگاپیکسل',
    },
    specificationsEn: {
      'Display': '12.9 inch Liquid Retina XDR',
      'Processor': 'Apple M2',
      'RAM': '8GB',
      'Storage': '256GB',
      'Camera': '12MP',
    },
    rating: 4.8,
    reviewCount: 95,
    isFeatured: true,
    isNew: false,
    discount: 10,
    tags: ['اپل', 'آیپد', 'تبلت'],
    createdAt: '2024-01-05T10:00:00Z',
    updatedAt: '2024-01-05T10:00:00Z',
  },
  {
    id: 'prod-6',
    name: 'هدفون سونی WH-1000XM5',
    nameEn: 'Sony WH-1000XM5',
    description: 'هدفون بی‌سیم با بهترین سیستم حذف نویز، صدای Hi-Res و باتری 30 ساعته.',
    descriptionEn: 'Wireless headphones with best noise cancellation, Hi-Res audio and 30-hour battery.',
    price: 18500000,
    originalPrice: 22000000,
    images: [
      'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=600',
    ],
    category: 'cat-4',
    stock: 30,
    sku: 'SONY-XM5',
    specifications: {
      'نوع': 'Over-ear بی‌سیم',
      'حذف نویز': 'Active Noise Cancellation',
      'باتری': '30 ساعت',
      'اتصال': 'Bluetooth 5.2',
      'وزن': '250 گرم',
    },
    specificationsEn: {
      'Type': 'Over-ear wireless',
      'Noise Cancellation': 'Active',
      'Battery': '30 hours',
      'Connection': 'Bluetooth 5.2',
      'Weight': '250g',
    },
    rating: 4.9,
    reviewCount: 312,
    isFeatured: true,
    isNew: false,
    discount: 16,
    tags: ['سونی', 'هدفون', 'نویز کنسلیشن'],
    createdAt: '2024-01-08T10:00:00Z',
    updatedAt: '2024-01-08T10:00:00Z',
  },
  {
    id: 'prod-7',
    name: 'اپل واچ Ultra 2',
    nameEn: 'Apple Watch Ultra 2',
    description: 'ساعت هوشمند ورزشی اپل با بدنه تیتانیوم، GPS دوگانه و مقاومت در برابر آب تا 100 متر.',
    descriptionEn: 'Apple sports smartwatch with titanium body, dual-frequency GPS and 100m water resistance.',
    price: 35000000,
    originalPrice: 38000000,
    images: [
      'https://images.unsplash.com/photo-1434493789847-2f02dc6ca35d?w=600',
    ],
    category: 'cat-5',
    stock: 20,
    sku: 'AW-ULTRA2',
    specifications: {
      'صفحه نمایش': '49 میلی‌متر Retina',
      'مواد': 'تیتانیوم',
      'GPS': 'دوگانه L1 + L5',
      'باتری': '36 ساعت',
      'مقاومت آب': '100 متر',
    },
    specificationsEn: {
      'Display': '49mm Retina',
      'Material': 'Titanium',
      'GPS': 'Dual L1 + L5',
      'Battery': '36 hours',
      'Water Resistance': '100m',
    },
    rating: 4.7,
    reviewCount: 145,
    isFeatured: false,
    isNew: true,
    discount: 8,
    tags: ['اپل', 'ساعت هوشمند', 'ورزشی'],
    createdAt: '2024-01-22T10:00:00Z',
    updatedAt: '2024-01-22T10:00:00Z',
  },
  {
    id: 'prod-8',
    name: 'دوربین سونی A7 IV',
    nameEn: 'Sony A7 IV',
    description: 'دوربین فول‌فریم میرورلس با سنسور 33 مگاپیکسلی، فوکوس خودکار پیشرفته و فیلم‌برداری 4K60p.',
    descriptionEn: 'Full-frame mirrorless camera with 33MP sensor, advanced autofocus and 4K60p video.',
    price: 92000000,
    originalPrice: 98000000,
    images: [
      'https://images.unsplash.com/photo-1516035069371-29a1b244cc32?w=600',
    ],
    category: 'cat-6',
    stock: 6,
    sku: 'SONY-A7IV',
    specifications: {
      'سنسور': '33 مگاپیکسل Full-Frame',
      'پردازنده': 'BIONZ XR',
      'فیلم‌برداری': '4K 60fps',
      'ISO': '100-51200',
      'وزن': '658 گرم',
    },
    specificationsEn: {
      'Sensor': '33MP Full-Frame',
      'Processor': 'BIONZ XR',
      'Video': '4K 60fps',
      'ISO': '100-51200',
      'Weight': '658g',
    },
    rating: 4.8,
    reviewCount: 67,
    isFeatured: true,
    isNew: false,
    discount: 6,
    tags: ['سونی', 'دوربین', 'فول‌فریم'],
    createdAt: '2024-01-12T10:00:00Z',
    updatedAt: '2024-01-12T10:00:00Z',
  },
  {
    id: 'prod-9',
    name: 'پلی‌استیشن 5',
    nameEn: 'PlayStation 5',
    description: 'کنسول نسل نه سونی با پردازنده قدرتمند، SSD فوق‌سریع و پشتیبانی از ری‌تریسینگ.',
    descriptionEn: 'Ninth generation Sony console with powerful processor, ultra-fast SSD and ray tracing support.',
    price: 28000000,
    originalPrice: 32000000,
    images: [
      'https://images.unsplash.com/photo-1606813907291-d86efa9b94db?w=600',
    ],
    category: 'cat-7',
    stock: 10,
    sku: 'PS5-STANDARD',
    specifications: {
      'پردازنده': 'AMD Ryzen Zen 2',
      'کارت گرافیک': 'AMD RDNA 2',
      'حافظه': '825 گیگابایت SSD',
      'رزولوشن': 'تا 4K',
      'نرخ فریم': 'تا 120fps',
    },
    specificationsEn: {
      'Processor': 'AMD Ryzen Zen 2',
      'Graphics': 'AMD RDNA 2',
      'Storage': '825GB SSD',
      'Resolution': 'Up to 4K',
      'Frame Rate': 'Up to 120fps',
    },
    rating: 4.9,
    reviewCount: 423,
    isFeatured: true,
    isNew: false,
    discount: 12,
    tags: ['سونی', 'گیمینگ', 'کنسول'],
    createdAt: '2024-01-03T10:00:00Z',
    updatedAt: '2024-01-03T10:00:00Z',
  },
  {
    id: 'prod-10',
    name: 'ماوس گیمینگ ریزر DeathAdder V3',
    nameEn: 'Razer DeathAdder V3 Pro',
    description: 'ماوس بی‌سیم فوق‌سبک با سنسور Focus Pro 30K، عمر باتری 90 ساعته و طراحی ارگونومیک.',
    descriptionEn: 'Ultra-light wireless mouse with Focus Pro 30K sensor, 90-hour battery and ergonomic design.',
    price: 6500000,
    originalPrice: 7800000,
    images: [
      'https://images.unsplash.com/photo-1527864550417-7fd91fc51a46?w=600',
    ],
    category: 'cat-7',
    stock: 40,
    sku: 'RAZER-DA-V3',
    specifications: {
      'سنسور': 'Focus Pro 30K',
      'دکمه‌ها': '5 دکمه',
      'باتری': '90 ساعت',
      'وزن': '63 گرم',
      'اتصال': 'HyperSpeed Wireless',
    },
    specificationsEn: {
      'Sensor': 'Focus Pro 30K',
      'Buttons': '5 buttons',
      'Battery': '90 hours',
      'Weight': '63g',
      'Connection': 'HyperSpeed Wireless',
    },
    rating: 4.7,
    reviewCount: 189,
    isFeatured: false,
    isNew: true,
    discount: 17,
    tags: ['ریزر', 'گیمینگ', 'ماوس'],
    createdAt: '2024-01-25T10:00:00Z',
    updatedAt: '2024-01-25T10:00:00Z',
  },
  {
    id: 'prod-11',
    name: 'کیبورد مکانیکی کیکرون K8 Pro',
    nameEn: 'Keychron K8 Pro',
    description: 'کیبورد مکانیکی 80 درصد با سوئیچ‌های Gateron، پشتیبانی از ویندوز/مک و اتصال Bluetooth/USB.',
    descriptionEn: '80% mechanical keyboard with Gateron switches, Windows/Mac support and Bluetooth/USB connection.',
    price: 5200000,
    originalPrice: 6000000,
    images: [
      'https://images.unsplash.com/photo-1595225476474-87563907a212?w=600',
    ],
    category: 'cat-8',
    stock: 25,
    sku: 'KEYCHRON-K8P',
    specifications: {
      'طرح': 'TKL (80%)',
      'سوئیچ': 'Gateron G Pro',
      'اتصال': 'Bluetooth/USB-C',
      'باتری': '200 ساعت',
      'نور پس‌زمینه': 'RGB',
    },
    specificationsEn: {
      'Layout': 'TKL (80%)',
      'Switch': 'Gateron G Pro',
      'Connection': 'Bluetooth/USB-C',
      'Battery': '200 hours',
      'Backlight': 'RGB',
    },
    rating: 4.6,
    reviewCount: 78,
    isFeatured: false,
    isNew: true,
    discount: 13,
    tags: ['کیبورد', 'مکانیکال', 'کیکرون'],
    createdAt: '2024-01-28T10:00:00Z',
    updatedAt: '2024-01-28T10:00:00Z',
  },
  {
    id: 'prod-12',
    name: 'هاب USB-C انکر 7 پورت',
    nameEn: 'Anker USB-C Hub 7-in-1',
    description: 'هاب چندکاره USB-C با HDMI 4K، پورت USB 3.0، کارت‌خوان و پورت شارژ PD.',
    descriptionEn: 'Multi-function USB-C hub with 4K HDMI, USB 3.0 ports, card reader and PD charging port.',
    price: 2800000,
    originalPrice: 3500000,
    images: [
      'https://images.unsplash.com/photo-1625766763788-95dcce9bf5ac?w=600',
    ],
    category: 'cat-8',
    stock: 50,
    sku: 'ANKER-HUB-7',
    specifications: {
      'پورت HDMI': '4K@30Hz',
      'پورت USB': '3x USB 3.0',
      'کارت‌خوان': 'SD/MicroSD',
      'شارژ': 'Power Delivery 100W',
      'سازگاری': 'MacBook, iPad, Windows',
    },
    specificationsEn: {
      'HDMI Port': '4K@30Hz',
      'USB Ports': '3x USB 3.0',
      'Card Reader': 'SD/MicroSD',
      'Charging': 'Power Delivery 100W',
      'Compatibility': 'MacBook, iPad, Windows',
    },
    rating: 4.5,
    reviewCount: 234,
    isFeatured: false,
    isNew: false,
    discount: 20,
    tags: ['انکر', 'هاب', 'USB-C'],
    createdAt: '2024-01-01T10:00:00Z',
    updatedAt: '2024-01-01T10:00:00Z',
  },
];

export const sampleBlogPosts: BlogPost[] = [
  {
    id: 'blog-1',
    title: 'راهنمای خرید لپ‌تاپ در سال 2024',
    titleEn: 'Laptop Buying Guide 2024',
    content: `خرید لپ‌تاپ مناسب یکی از مهم‌ترین تصمیم‌هایی است که باید بگیرید. در این راهنما، به بررسی نکات کلیدی برای انتخاب بهترین لپ‌تاپ می‌پردازیم.

## 1. تعیین بودجه
اولین قدم در خرید لپ‌تاپ، تعیین بودجه است. لپ‌تاپ‌ها در رنج‌های قیمتی مختلفی عرضه می‌شوند و باید متناسب با نیاز و بودجه خود انتخاب کنید.

## 2. نوع استفاده
- **استفاده روزمره**: برای کارهای عادی مانند وب‌گردی و پردازش متن
- **گیمینگ**: نیاز به کارت گرافیک قدرتمند
- **حرفه‌ای**: برای طراحی و ویرایش ویدیو

## 3. مشخصات فنی
- **پردازنده**: Intel Core i5/i7 یا AMD Ryzen 5/7
- **رم**: حداقل 8 گیگابایت
- **حافظه**: SSD برای سرعت بالاتر

## نتیجه‌گیری
با توجه به نیازهای خود و بودجه‌تان، بهترین انتخاب را داشته باشید.`,
    contentEn: `Buying the right laptop is one of the most important decisions you'll make. In this guide, we review key points for choosing the best laptop.

## 1. Set Your Budget
The first step is determining your budget. Laptops come in various price ranges.

## 2. Usage Type
- **Everyday use**: For normal tasks like browsing and word processing
- **Gaming**: Requires powerful graphics card
- **Professional**: For design and video editing

## 3. Technical Specs
- **Processor**: Intel Core i5/i7 or AMD Ryzen 5/7
- **RAM**: At least 8GB
- **Storage**: SSD for better performance

## Conclusion
Choose according to your needs and budget.`,
    excerpt: 'راهنمای جامع برای انتخاب بهترین لپ‌تاپ متناسب با نیاز و بودجه شما',
    excerptEn: 'Comprehensive guide for choosing the best laptop according to your needs and budget',
    image: 'https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=800',
    author: 'تیم تحریریه',
    category: 'راهنمای خرید',
    tags: ['لپ‌تاپ', 'راهنمای خرید', 'تکنولوژی'],
    views: 1250,
    isPublished: true,
    createdAt: '2024-01-20T10:00:00Z',
    updatedAt: '2024-01-20T10:00:00Z',
  },
  {
    id: 'blog-2',
    title: 'معرفی آیفون 15: انقلاب در دنیای موبایل',
    titleEn: 'iPhone 15 Introduction: Revolution in Mobile World',
    content: `اپل با معرفی آیفون 15، بار دیگر استانداردهای صنعت موبایل را تغییر داد. در این مقاله به بررسی ویژگی‌های کلیدی این گوشی می‌پردازیم.

## طراحی جدید
آیفون 15 با بدنه تیتانیوم سبک‌تر و مقاوم‌تر از همیشه عرضه شده است. پورت USB-C جایگزین لایتنینگ شده و سرعت انتقال داده را بهبود بخشیده است.

## دوربین پیشرفته
سیستم دوربین 48 مگاپیکسلی با قابلیت‌های جدید عکاسی و فیلم‌برداری، تجربه‌ای بی‌نظیر ارائه می‌دهد.

## پردازنده A17 Pro
چیپست جدید اپل با معماری 3 نانومتری، عملکردی فوق‌العاده و مصرف انرژی بهینه دارد.`,
    contentEn: `Apple has once again changed industry standards with the iPhone 15. In this article, we review the key features of this phone.

## New Design
The iPhone 15 features a lighter and more durable titanium body. USB-C replaces Lightning, improving data transfer speeds.

## Advanced Camera
The 48MP camera system with new photography and videography capabilities provides an unparalleled experience.

## A17 Pro Processor
Apple's new 3nm chipset delivers exceptional performance with optimized power consumption.`,
    excerpt: 'بررسی کامل ویژگی‌های جدید آیفون 15 و تغییرات انقلابی آن',
    excerptEn: 'Complete review of iPhone 15 features and its revolutionary changes',
    image: 'https://images.unsplash.com/photo-1696446701796-da61225697cc?w=800',
    author: 'علی محمدی',
    category: 'نقد و بررسی',
    tags: ['اپل', 'آیفون', 'موبایل'],
    views: 2100,
    isPublished: true,
    createdAt: '2024-01-25T10:00:00Z',
    updatedAt: '2024-01-25T10:00:00Z',
  },
  {
    id: 'blog-3',
    title: 'بهترین هدفون‌های 2024 برای موسیقی',
    titleEn: 'Best Headphones 2024 for Music',
    content: `اگر به دنبال بهترین هدفون برای گوش دادن به موسیقی هستید، این مقاله راهنمای کاملی برای شماست.

## سونی WH-1000XM5
بهترین سیستم حذف نویز، صدای Hi-Res عالی و باتری 30 ساعته. قیمت: حدود 18 میلیون تومان.

## اپل AirPods Max
صدای فضایی با Dolby Atmos، طراحی لوکس و اکوسیستم کامل اپل. قیمت: حدود 25 میلیون تومان.

## سمهایزر Momentum 4
کیفیت صدای استثنایی، راحتی بالا و اپلیکیشن قدرتمند. قیمت: حدود 15 میلیون تومان.`,
    contentEn: `If you're looking for the best headphones for music listening, this article is a complete guide for you.

## Sony WH-1000XM5
Best noise cancellation, excellent Hi-Res audio and 30-hour battery. Price: around $400.

## Apple AirPods Max
Spatial audio with Dolby Atmos, luxurious design and complete Apple ecosystem. Price: around $550.

## Sennheiser Momentum 4
Exceptional sound quality, high comfort and powerful app. Price: around $380.`,
    excerpt: 'مقایسه بهترین هدفون‌های بازار برای دوستداران موسیقی',
    excerptEn: 'Comparison of best headphones on the market for music lovers',
    image: 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=800',
    author: 'سارا کریمی',
    category: 'مقایسه محصولات',
    tags: ['هدفون', 'موسیقی', 'صدا'],
    views: 980,
    isPublished: true,
    createdAt: '2024-01-28T10:00:00Z',
    updatedAt: '2024-01-28T10:00:00Z',
  },
  {
    id: 'blog-4',
    title: 'راهنمای شروع گیمینگ حرفه‌ای',
    titleEn: 'Guide to Starting Professional Gaming',
    content: `اگر به دنیای گیمینگ حرفه‌ای علاقه دارید، این راهنما به شما کمک می‌کند بهترین شروع را داشته باشید.

## تجهیزات اولیه
- **کامپیوتر یا کنسول**: متناسب با بودجه و بازی‌های مورد علاقه
- **مانیتور**: حداقل 144 هرتز برای تجربه روان
- **ماوس و کیبورد**: ارگونومیک و با دقت بالا
- **هدست**: با میکروفون باکیفیت برای ارتباط تیمی

## بهبود مهارت‌ها
- تمرین منظم روزانه
- تماشای بازی‌های حرفه‌ای
- یادگیری از اشتباهات

## سلامتی
- استراحت‌های منظم
- وضعیت صحیح نشستن
- مراقبت از چشم‌ها`,
    contentEn: `If you're interested in professional gaming, this guide will help you have the best start.

## Essential Equipment
- **PC or Console**: According to budget and favorite games
- **Monitor**: At least 144Hz for smooth experience
- **Mouse and Keyboard**: Ergonomic and high precision
- **Headset**: With quality microphone for team communication

## Improving Skills
- Regular daily practice
- Watching professional games
- Learning from mistakes

## Health
- Regular breaks
- Proper sitting posture
- Eye care`,
    excerpt: 'نکات کلیدی برای ورود به دنیای گیمینگ حرفه‌ای',
    excerptEn: 'Key tips for entering the world of professional gaming',
    image: 'https://images.unsplash.com/photo-1542751371-adc38448a05e?w=800',
    author: 'رضا احمدی',
    category: 'گیمینگ',
    tags: ['گیمینگ', 'بازی', 'راهنما'],
    views: 1560,
    isPublished: true,
    createdAt: '2024-01-30T10:00:00Z',
    updatedAt: '2024-01-30T10:00:00Z',
  },
];

export const sampleBanners: Banner[] = [
  {
    id: 'banner-1',
    title: 'فروش ویژه زمستانه',
    titleEn: 'Winter Special Sale',
    subtitle: 'تا 50% تخفیف روی محصولات منتخب',
    subtitleEn: 'Up to 50% off on selected products',
    image: 'https://images.unsplash.com/photo-1607082348824-0a96f2a4b9da?w=1200',
    link: '/products?discount=true',
    buttonText: 'مشاهده محصولات',
    buttonTextEn: 'View Products',
    isActive: true,
    sortOrder: 1,
  },
  {
    id: 'banner-2',
    title: 'جدیدترین لپ‌تاپ‌های 2024',
    titleEn: 'Latest 2024 Laptops',
    subtitle: 'با گارانتی 2 ساله و ارسال رایگان',
    subtitleEn: 'With 2-year warranty and free shipping',
    image: 'https://images.unsplash.com/photo-1496181133206-80ce9b88a853?w=1200',
    link: '/category/cat-1',
    buttonText: 'مشاهده لپ‌تاپ‌ها',
    buttonTextEn: 'View Laptops',
    isActive: true,
    sortOrder: 2,
  },
  {
    id: 'banner-3',
    title: 'هدفون‌های حرفه‌ای',
    titleEn: 'Professional Headphones',
    subtitle: 'تجربه صدای بی‌نظیر',
    subtitleEn: 'Experience unparalleled sound',
    image: 'https://images.unsplash.com/photo-1505740420928-5e560c06d30e?w=1200',
    link: '/category/cat-4',
    buttonText: 'مشاهده هدفون‌ها',
    buttonTextEn: 'View Headphones',
    isActive: true,
    sortOrder: 3,
  },
];
