// Types for Digital Shop

export interface Product {
  id: string;
  name: string;
  nameEn: string;
  description: string;
  descriptionEn: string;
  price: number;
  originalPrice?: number;
  images: string[];
  category: string;
  subcategory?: string;
  stock: number;
  sku: string;
  specifications: Record<string, string>;
  specificationsEn: Record<string, string>;
  rating: number;
  reviewCount: number;
  isFeatured: boolean;
  isNew: boolean;
  discount?: number;
  tags: string[];
  createdAt: string;
  updatedAt: string;
}

export interface Category {
  id: string;
  name: string;
  nameEn: string;
  description: string;
  descriptionEn: string;
  image: string;
  icon: string;
  parentId?: string;
  sortOrder: number;
  isActive: boolean;
}

export interface BlogPost {
  id: string;
  title: string;
  titleEn: string;
  content: string;
  contentEn: string;
  excerpt: string;
  excerptEn: string;
  image: string;
  author: string;
  category: string;
  tags: string[];
  views: number;
  isPublished: boolean;
  createdAt: string;
  updatedAt: string;
}

export interface CartItem {
  product: Product;
  quantity: number;
}

export interface User {
  id: string;
  name: string;
  email: string;
  phone?: string;
  address?: string;
  isAdmin: boolean;
  createdAt: string;
}

export interface Order {
  id: string;
  userId: string;
  items: CartItem[];
  totalAmount: number;
  status: 'pending' | 'processing' | 'shipped' | 'delivered' | 'cancelled';
  paymentStatus: 'pending' | 'paid' | 'failed';
  shippingAddress: string;
  phone: string;
  notes?: string;
  createdAt: string;
  updatedAt: string;
}

export interface SiteSettings {
  siteName: string;
  siteNameEn: string;
  logo: string;
  favicon: string;
  description: string;
  descriptionEn: string;
  keywords: string;
  phone: string;
  email: string;
  address: string;
  socialLinks: {
    instagram?: string;
    telegram?: string;
    whatsapp?: string;
    twitter?: string;
  };
  footerText: string;
  footerTextEn: string;
  maintenanceMode: boolean;
}

export interface Banner {
  id: string;
  title: string;
  titleEn: string;
  subtitle: string;
  subtitleEn: string;
  image: string;
  link: string;
  buttonText: string;
  buttonTextEn: string;
  isActive: boolean;
  sortOrder: number;
}

export type Language = 'fa' | 'en';
export type Theme = 'light' | 'dark';
